<?php
	$category = $wp_query->get_queried_object();
	
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	$blog_posts = new WP_Query(array(
		'post_type'     => 'post',
		'post_status'   => 'publish',
		'paged'         => $paged,
		'posts_per_page'=> 5,
		'cat' => $category->term_id
	));
?>
<?php get_header();?>
<section id="category_posts" class="category_posts">
	<div class="container">
		<div class="left_content">
			<div class="breadcrumb"> 
				<ul>
					<li><a href="<?=home_url();?>">Home</a></li>
					<li class="current"><p><?=$category->name;?></p></li>
				</ul>
			</div>
			<div class="posts_container">
				<div class="outer_posts_container">
					<?php while ( $blog_posts->have_posts() ) : $blog_posts->the_post(); ?>
						<?php $featured_image = get_the_post_thumbnail_url($post->ID); ?>
						<div class="post_item">
							<div class="thumbnail_container" >
								<?php if(empty($featured_image)):?>
									<?php if($category->term_id == 8):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/default_img.jpg');background-size: cover;"></div>
									<?php elseif($category->term_id == 6):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/dinspre_mine.jpg');background-size: cover;"></div>
									<?php elseif($category->term_id == 7):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/fara_roba.jpg');background-size: cover;"></div>
									<?php elseif($category->term_id == 4):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/invitati.jpg');background-size: cover;"></div>
									<?php elseif($category->term_id == 2):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/opinii.jpg');background-size: cover;"></div>
									<?php elseif($category->term_id == 3):?>
										<div class="background" style="background-image: url('<?=get_template_directory_uri();?>/assets/images/cartile_mele.jpg');background-size: cover;"></div>
									<?php endif;?>
								<?php else:?>
									<div class="background" style="background-image: url('<?=$featured_image;?>'); background-size: cover;"></div>
								<?php endif;?>
								
							</div>
							<div class="right_details">
								<?php 									
									$title = $post->post_title;
									$title = str_replace('&nbsp;', '', $title);
									$title = str_replace("\u{00A0}", "", $title);
									
									$description = substr(strip_shortcodes(wp_strip_all_tags($post->post_content)), 0, 120);
									$description = str_replace('&nbsp;', '', $description);
									$description = str_replace("\u{00A0}", "", $description);
								?>
								<div class="name">
									<a href="<?= get_permalink($post->ID);?>"><?=$title;?></a>
								</div>
								<div class="date_and_categ">
									<p><span class="date"><?=get_the_date('j F, Y', $post->ID);?></span></p>
								</div>
								<div class="post_description">
									<p><?=$description;?></p>
								</div>
								<div class="read_more">
									<a href="<?= get_permalink($post->ID);?>"><span>Citește în continuare</span></a>
								</div>
							</div>
							
						</div>
					<?php endwhile;?>
				</div>
			</div>
			<div class="pagination">
				<?php
					echo paginate_links( array(
						'format'  => 'page/%#%',
						'current' => $paged,
						'total'   => $blog_posts->max_num_pages,
						'mid_size'        => 2,
						'prev_text'       => __('&lsaquo;'),
						'next_text'       => __('&rsaquo;')
					) );
				?>
			</div>
        </div>
       
		<?php
			 $view_args = array(
				'posts_per_page' => 10,
				'post_type' => 'post'
			);
			$posts = get_posts($view_args);
		?>
		<div class="right_sidebar">
			<div class="sidebar_box">
				<h3>10, cele mai citite articole</h3>
				<ul>
					<?php foreach($posts as $k => $v):?>
						<?php
							$post_views = get_post_views($v->ID);
						?>
						<li class="item">
							<a href="<?=get_permalink($v->ID);?>"><?=$v->post_title;?></a>
							<div class="views"><?=$post_views;?> VIZUALIZARI</div>
						</li>
					<?php endforeach;?>
				</ul>
			</div>
		</div>
	</div>
</section>
<?php get_footer();?>