<!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?> style="margin-top:0 !important">
	<head>
		<link rel="preconnect" href="https://fonts.gstatic.com">
		<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
		<link href="https://fonts.googleapis.com/css2?family=Playfair+Display&display=swap" rel="stylesheet">
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<link rel="stylesheet" href="<?=get_template_directory_uri();?>/assets/css/slick.css">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<header>
	<div class="header_container">
		<div class="column left">
			<a href="<?=home_url();?>">
				<svg width="183" height="14" viewBox="0 0 183 14" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M13.2909 14L13.2709 3.8L8.21094 12.3H7.29094L2.23094 3.86V14H0.310938V-9.53674e-07H1.95094L7.79094 9.84L13.5509 -9.53674e-07H15.1909L15.2109 14H13.2909ZM30.3325 10.5H22.8925L21.3525 14H19.2925L25.6325 -9.53674e-07H27.6125L33.9725 14H31.8725L30.3325 10.5ZM29.6325 8.9L26.6125 2.04L23.5925 8.9H29.6325ZM47.4209 14L44.4009 9.7C44.0276 9.72667 43.7343 9.74 43.5209 9.74H40.0609V14H38.0609V-9.53674e-07H43.5209C45.3343 -9.53674e-07 46.7609 0.433332 47.8009 1.3C48.8409 2.16667 49.3609 3.36 49.3609 4.88C49.3609 5.96 49.0943 6.88 48.5609 7.64C48.0276 8.4 47.2676 8.95333 46.2809 9.3L49.6009 14H47.4209ZM43.4609 8.04C44.7276 8.04 45.6943 7.76667 46.3609 7.22C47.0276 6.67333 47.3609 5.89333 47.3609 4.88C47.3609 3.86667 47.0276 3.09333 46.3609 2.56C45.6943 2.01333 44.7276 1.74 43.4609 1.74H40.0609V8.04H43.4609ZM54.5922 -9.53674e-07H56.5922V14H54.5922V-9.53674e-07ZM71.7036 10.5H64.2636L62.7236 14H60.6636L67.0036 -9.53674e-07H68.9836L75.3436 14H73.2436L71.7036 10.5ZM71.0036 8.9L67.9836 2.04L64.9636 8.9H71.0036ZM91.472 -9.53674e-07V14H89.832L81.432 3.56V14H79.432V-9.53674e-07H81.072L89.472 10.44V-9.53674e-07H91.472ZM117.434 -9.53674e-07V14H114.774L107.794 5.5V14H104.594V-9.53674e-07H107.274L114.234 8.5V-9.53674e-07H117.434ZM131.966 11H125.466L124.226 14H120.906L127.146 -9.53674e-07H130.346L136.606 14H133.206L131.966 11ZM130.946 8.54L128.726 3.18L126.506 8.54H130.946ZM151.398 11.36V14H139.158V11.9L146.838 2.64H139.318V-9.53674e-07H151.098V2.1L143.438 11.36H151.398ZM164.696 11H158.196L156.956 14H153.636L159.876 -9.53674e-07H163.076L169.336 14H165.936L164.696 11ZM163.676 8.54L161.456 3.18L159.236 8.54H163.676ZM174.986 2.64H170.506V-9.53674e-07H182.706V2.64H178.226V14H174.986V2.64Z" fill="black"/>
				</svg>
			</a>
			<div class="professions">
				<ul>
					<li>
						avocat
					</li>
					<li>
						scriitor
					</li>
					<li>
						publicist
					</li>
				</ul>
			</div>
		</div>
		<div class="column center">
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => 'ul', 'menu_class' => 'top_menu' ) ); ?>
		</div>
		<div class="column right">
			<div class="send_mail">
				<a href="mailto:mnazat@mariannazat.ro">
					<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M13.1819 4.6728L8.00065 9.23855L2.81823 4.67274C2.61187 4.49094 2.29733 4.51092 2.1156 4.71714C1.93394 4.92343 1.95372 5.23797 2.16007 5.41977L7.67164 10.2756C7.76569 10.3584 7.88324 10.3998 8.00072 10.3998C8.1182 10.3998 8.23581 10.3584 8.32986 10.2755L13.8403 5.4197C14.0465 5.23797 14.0664 4.92336 13.8846 4.71707C13.7028 4.51099 13.3883 4.49107 13.1819 4.6728Z" fill="black"/>
						<path d="M14.5066 2.55728H1.4934C0.669972 2.55728 0 3.22719 0 4.05068V11.9492C0 12.7727 0.669972 13.4426 1.4934 13.4426H14.5066C15.33 13.4426 16 12.7727 16 11.9492V4.05068C16 3.22725 15.33 2.55728 14.5066 2.55728ZM15.0044 11.9492C15.0044 12.2237 14.7811 12.447 14.5066 12.447H1.4934C1.21888 12.447 0.995599 12.2237 0.995599 11.9492V4.05068C0.995599 3.77623 1.21888 3.55288 1.4934 3.55288H14.5066C14.7811 3.55288 15.0044 3.77623 15.0044 4.05068V11.9492Z" fill="black"/>
					</svg>
				</a>
			</div>
			<div class="search_container">
				<button>
					<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_19_266)">
						<path d="M6.17349 0.0168152C2.76946 0.0168152 0 2.7787 0 6.17346C0 9.56822 2.76949 12.3301 6.17349 12.3301C9.57749 12.3301 12.347 9.56822 12.347 6.17346C12.347 2.7787 9.57752 0.0168152 6.17349 0.0168152ZM6.17349 11.318C3.32744 11.318 1.01205 9.01006 1.01205 6.17344C1.01205 3.33665 3.32744 1.02884 6.17349 1.02884C9.01954 1.02884 11.3349 3.33665 11.3349 6.17344C11.335 9.01006 9.01957 11.318 6.17349 11.318Z" fill="black"/>
						<path d="M13.851 13.1183L10.5281 9.81231C10.3299 9.6153 10.0095 9.61615 9.81237 9.81417C9.61536 10.0124 9.61621 10.3327 9.81423 10.5299L13.1371 13.8359C13.236 13.9341 13.3649 13.9831 13.4941 13.9831C13.6241 13.9831 13.754 13.9334 13.8528 13.834C14.0498 13.6358 14.049 13.3155 13.851 13.1183Z" fill="black"/>
						</g>
						<defs>
						<clipPath id="clip0_19_266">
						<rect width="14" height="14" fill="white"/>
						</clipPath>
						</defs>
					</svg>
				</button>
			</div>
		</div>
		<div class="header_mobile_menu">
			<div class="mobile_menu_content">
				<button class="trigger_content">
					<span></span>
					<span></span>
					<span></span>
				</button>
				<div class="trigger_menu_and_search">
					<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => 'ul', 'menu_class' => 'top_menu' ) ); ?>
					<div class="search_container">
						<div id="search_popup_box" class="mobile">
							<div class="container">
								<div class="inner_content">
									<?php get_search_form(); ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>
