<?php get_header(); ?>
<?php
	$categories = wp_get_post_categories($post->ID);
	$featured_image = get_the_post_thumbnail_url($post->ID);
	
	$date = $post->post_date_gmt;
	$formatted_date = date('d F, Y', strtotime($date));
	
	$category = get_the_category();
	$category_name = $category[0]->name;
	
	$category_link = get_category_link($category[0]->term_id);
?>

<section id="single_post" class="singe_post">
	<div class="single_page_container">
		<div class="post_container left">
			<div class="breadcrumb">
				<ul>
					<li>
						<a href="/">Home</a>
					</li>
					<li>
						<a href="<?=$category_link;?>"><?=$category_name?></a>
					</li>
					<li>
						<span>
							<?=$post->post_title;?>
						</span>
					</li>
				</ul>
			</div>
			<div class="title">
				<h1><?=$post->post_title;?></h1>
			</div>
			<div class="post_date">
				<?=$formatted_date;?>
			</div>
			<div class="featured_image">
				<?php if(empty($featured_image)):?>
					<img src="<?=get_template_directory_uri();?>/assets/images/new_default_image.png">
				<?php else:?>
					<img src="<?=$featured_image;?>">
				<?php endif;?>
			</div>
			
			<div class="post_content">
				<?php echo apply_filters( 'the_content', get_post_field('post_content', $post->ID)); ?>
			</div>
					
			<div class="mailchimp_form">
				<div class="form_content">
					<div class="title">Va puteți abona la articole prin e-mail:</div>
					<?php echo do_shortcode('[mc4wp_form id=14388]');?>	
				</div>
			</div>
			
			<?php
				$exclude_post_id = $post->ID;
			    $view_argss = array(
			        'posts_per_page' => 3,
			        'post_type' => 'post',
			        'category_name' => $category_name,
			        'post__not_in' => array($exclude_post_id)
			        
			    );
			    $postss = get_posts($view_argss);
			?>
			<div class="read_too">
				<h2>Citeste si...</h2>
				
				<div id="category_posts">
					<?php foreach($postss as $key => $value):?>
						<?php 									
							$title = $value->post_title;
							$title = str_replace('&nbsp;', '', $title);
							$title = str_replace("\u{00A0}", "", $title);
							
							$description = substr(strip_shortcodes(wp_strip_all_tags($post->post_content)), 0, 120);
							$description = str_replace('&nbsp;', '', $description);
							$description = str_replace("\u{00A0}", "", $description);
						?>
						<div class="post_item">
							<div class="left_content">
								<div class="right_details">
									<div class="name">
										<a href="<?= get_permalink($value->ID);?>"><?=$title;?></a>
									</div>
									<div class="date_and_categ">
										<p><span class="date"><?=get_the_date('j F, Y', $value->ID);?></span></p>
									</div>
									<div class="post_description">
										<p><?=$description;?></p>
									</div>
									<div class="read_more">
										<a href="<?= get_permalink($value->ID);?>"><span>Citește în continuare</span></a>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach;?>
				</div>
			</div>
		</div>
		
		<?php
		    $view_args = array(
		        'posts_per_page' => 10,
		        'post_type' => 'post',
		        'category_name' => $category_name
		    );
		    $posts = get_posts($view_args);
		?>
		<div class="right">
			<div class="similar_articles">
				<div class="medium_size_opacity_title">
					<h2>Articole similare</h2>
				</div>
				<?php foreach($posts as $key => $value):?>
					<?php
                        $post_views = do_shortcode('[post-views id="'.$value->ID.'"]');
                    ?>
					<div class="box">
						<a href="<?=get_permalink($value->ID);?>"><?=$value->post_title;?></a>
                        <div class="views"><?=$post_views;?> VIZUALIZARI</div>
					</div>
				<?php endforeach;?>
			</div>
		</div>
		
	</div>
</section>

<?php get_footer(); ?>
