<?php
    /*
    * Template name: Home
    */
?>
<?php get_header();?>

<?php
 	$allowed_ip = '86.120.44.14';
	
	if ($_SERVER['REMOTE_ADDR'] === $allowed_ip) {
		if (isset($_SESSION['success_message'])) {
		  echo $_SESSION['success_message'];
		  unset($_SESSION['success_message']);
		}
	}
 ?>

<form id="unsubscribe-form" style="display: none;">
  <p>Dezabonare newsletter</p>
  <label for="mailchimp_unsubscribed">E-mail:</label>
  <input type="email" id="mailchimp_unsubscribed" name="mailchimp_unsubscribed" required>
  <input type="submit" value="Dezabonare"></input>
  <p id="mailchimp_message"></p>
</form>

<section id="new_first_section" class="new_first_section">
	<div class="big_container">
		<div class="flex">
			<div class="col-3">
				<div class="about_me_text">
					<div class="sign">
						<svg width="16" height="12" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M10.1836 11.6836H13.4336L15.5664 7.31641V0.816406H9.06641V7.31641H12.3164L10.1836 11.6836ZM1.5 11.6836H4.75L6.93359 7.31641V0.816406H0.433594V7.31641H3.68359L1.5 11.6836Z" fill="black"/>
						</svg>
					</div>
					<p>Scriu întruna, altminteri  m-aș usca, scriu ca să nu uit 
					că exist, scriu pentru a  nu lăsa buruienile  să 
					crească peste o lume deja moartă, scriu…</p>
					<div class="line">
						<div class="icon">
							<span></span>
						</div>
						<div class="text">
							Despre mine
						</div>
					</div>
				</div>
				<div class="profile_image">
					<img src="<?=get_template_directory_uri();?>/assets/images/profile_image_v2.png">
				</div>	
			</div>
			<div class="col-4">
				<?php
				    $args = array(
				        'post_type' => 'post',
				        'posts_per_page' => 100,
				        'orderby' => 'date',
				        'order' => 'DESC'
				    );
				    $recent_post = get_posts($args);
				?>
				<div class="boxes">
					<?php foreach($recent_post as $post):?>
					<?php 
						$featured_image = get_the_post_thumbnail($post->ID, 'square');
				    	$categories = wp_get_post_categories($post->ID);
					?>
					<div class="box">
						<div class="thumb">
						    <?php if(empty($featured_image)):?>
			                    <img src="<?=get_template_directory_uri();?>/assets/images/new_default_image.png">
			                <?php else:?>
			                    <img src=<?=$featured_image;?>
			                <?php endif;?>
						</div>
						<div class="date_and_category">
							<span class="date"><?=get_the_date('j F, Y', $post->ID);?></span>
							<div class="bullet"><span></span></div>
	                        <?php if(!empty($categories)):?>
	                            <div class="categories_list">
	                                <ul>
	                                    <?php foreach($categories as $k => $v):?>
	                                        <?php
	                                            $category = get_category($v);
	                                        ?>
	                                        <li><a href="<?=get_category_link($category);?>"><?=$category->name;?></a></li>  
	                                    <?php endforeach;?>
	                                </ul>
	                            </div>
	                        <?php endif;?>
						</div>
						<div class="title">
		                    <h2><a href="<?=get_permalink($post->ID);?>"><?=$post->post_title;?></a></h2>
		                </div>
			            <div class="description">
		                    <p><?=substr(strip_shortcodes(wp_strip_all_tags($post->post_content)), 0, 200);?></p>
		                </div>
		                <div class="read_more">
		                    <a href="<?=get_permalink($post->ID);?>"><span></span>Continuare</a>
		                </div>
					</div>
					<?php endforeach;?>
				</div>
			</div>
			<div class="col-3">
				<div class="medium_size_opacity_title">
					<h2>cele mai citite articole</h2>
				</div>
				<div class="most_viewed">
					<?php
					    $view_args = array(
					        'posts_per_page' => 10,
					        'post_type' => 'post'
					    );
					    $posts = get_posts($view_args);
					?>
					
					<?php foreach($posts as $k => $v):?>
	                    <?php
	                    	$post_views = do_shortcode('[post-views id="'.$v->ID.'"]');
	                    ?>
	                    <div class="item">
	                        <a href="<?=get_permalink($v->ID);?>"><?=$v->post_title;?></a>
	                        <div class="views"><?=$post_views;?> VIZUALIZARI</div>
	                    </div>
	                <?php endforeach;?>
				</div>
			</div>
		</div>
	</div>
</section>

<script>
	jQuery(function(){
		jQuery('#unsubscribe-form').submit(function(event){
			event.preventDefault();
			var formData = jQuery(this).serialize();
			
			jQuery.ajax({
				url: '<?php echo admin_url("admin-ajax.php"); ?>',
				type: 'POST',
				data: formData,
				success: function(response) {
	                //location.reload();
	                console.log(response);
	            },
	            error: function(xhr, status, error) {
					//location.reload();
	            }
			})
		})
	})
</script>


<?php get_footer();?>